<?php

/*
	HTAM_Captcha - outil anti-bots
	Copyright(C) 2011 Nicolas SEICHEPINE

	This file is part of HTAM_Captcha
	
	HTAM_Captcha is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
	
	Contact : nicolas.seichepine.org/?action=contact
*/

function contact()
{
	$affich_form=true; // Formulaire affich par dfaut
	
	// Valeurs de compltion du formulaire par dfaut - issues d'un envoi prcdent
	$from_p1="";
	$from_p2="";
	$text_me="";
	
	if (isset($_SESSION['post'])) // Le formulaire a t valid
	{
		$affich_form=false; // A priori, on ne rutilisera pas le formulaire
		
		$_POST=$_SESSION['post'];
		unset($_SESSION['post']);
	
		// Vrifications diverses
		$check_1=(isset($_POST["from_first_part"]) && is_string($_POST["from_first_part"]) && !empty($_POST["from_first_part"]));
		$check_2=(isset($_POST["from_second_part"]) && is_string($_POST["from_second_part"]) && !empty($_POST["from_second_part"]));
		$check_3=(isset($_POST["message"]) && is_string($_POST["message"]) && !empty($_POST["message"]));
		$check_4=(isset($_POST["captcha"]) && is_string($_POST["captcha"]) && !empty($_POST["captcha"]));
		$check_5=(ctype_digit($_POST["captcha"]));
		$check_6=($_POST["captcha"]==$_SESSION['expected_captcha']);
		
		// Messages d'erreur selon les cas - on note les valeurs dj entres - on signale que le formulaire doit tre raffich le cas chant
		if (!$check_1)
		{
			echo('<div class="warning">Merci de pr&eacute;ciser votre nom</div>');
			$affich_form=true;
		}
		else
		{
			$from_p1=htmlentities($_POST["from_first_part"]);
		}
		if (!$check_2)
		{
			echo('<div class="warning">Merci de laisser un moyen de vous recontacter</div>');
			$affich_form=true;
		}
		else
		{
			$from_p2=htmlentities($_POST["from_second_part"]);
		}
		if (!$check_3)
		{
			echo('<div class="warning">Le corps du message est vide</div>');
			$affich_form=true;
		}
		else
		{
			$text_me=htmlentities($_POST["message"]);
		}
		if (!$check_4)
		{
			echo('<div class="warning">La r&eacute;ponse au captcha est vide</div>');
			$affich_form=true;
		}
		else
		{
			if (!$check_5)
			{
				echo('<div class="warning">La r&eacute;ponse au captcha devrait &ecirc;tre un entier (par exemple "78")</div>');
				$affich_form=true;
			}
			else
			{
				if (!$check_6)
				{
					echo('<div class="warning">La valeur fournie au captcha est erron&eacute;e</div>');
					$affich_form=true;
				}
			}
		}
		
		if(!$affich_form)
		{
			// $from_p2 n'est pas ncessairement une adresse mail - un header from peut-tre ncessaire selon le serveur et php.ini
			if(@mail('destinataire@domain.org',
				'Formulaire de contact',
				'Expditeur : '.stripslashes(html_entity_decode($from_p1))."\nContact : ".stripslashes(html_entity_decode($from_p2))."\n\n".stripslashes(html_entity_decode($text_me))))
			{
				echo('<div class="success">Mail correctement transmis</div>');
			}
			else
			{
				echo('<div class="warning">Probl&egrave;me lors de l\'envoi du mail, r&eacute;essayer plus tard</div><div class="margin"></div>');
				$affich_form=true;
			}
		}
		else
		{
			echo('<div class="margin"></div>');
		}		
	}
	
	if ($affich_form)
	{
	
		// Gestion du captcha
		$multiplier=rand(1,10);
		$negat=rand(0,5);
		$posit=rand(6,10);
		$_SESSION['expected_captcha']=($posit-$negat)*$multiplier;
		$_SESSION['p1']=$multiplier.'.png';
		$_SESSION['p2']=$negat.'.png';
		$_SESSION['p3']=$posit.'.png';

		echo('
			<form method="post" action="?action=contact">
				<table class="tab_form">
					<tr>
						<td class="firstcol">
							Destinataire :
						</td>
						<td>
							<select name="to">
								<option value="0" selected="selected">Nicolas Seichepine</option>
							</select>
						</td>
					</tr>
					<tr>
						<td class="firstcol">
							Exp&eacute;diteur :
						</td>
						<td>
							<input type="text" name="from_first_part" value="'.$from_p1.'"/>
						</td>
					</tr>
					<tr>
						<td class="firstcol">
							Contact exp&eacute;diteur :
						</td>
						<td>
							<input type="text" name="from_second_part" value="'.$from_p2.'"/>
						</td>
					</tr>
					<tr>
						<td class="firstcol">
							Corps du message :
						</td>
						<td>
							<textarea name="message" rows="10" cols="10" class="text_message">'.$text_me.'</textarea>
						</td>
					</tr>
					<tr>
						<td colspan="2" rowspan="1" class="form_spacer">
						</td>
					</tr>
					<tr>
						<td colspan="2" rowspan="1" class="form_center">
							Pour lutter contre les robots, merci de saisir (numriquement) le rsultat de l\'op&eacute;ration telle qu\'elle s\'affiche :
						</td>
					</tr>
					<tr>
						<td colspan="2" rowspan="1" class="form_spacer">
						</td>
					</tr>
					<tr>
						<td class="firstcol">
							<img src="./pub_img/interrog.png" alt="" class="im_captcha"/>
							<img src="./stream_file_1.php" alt="" class="im_captcha" />
							<img src="./pub_img/fois.png" alt="" class="im_captcha" />
							<img src="./pub_img/par_ferm.png" alt="" class="im_captcha" />
							<img src="./stream_file_2.php" alt="" class="im_captcha" />		
							<img src="./pub_img/moins.png" alt="" class="im_captcha" />		
							<img src="./stream_file_3.php" alt="" class="im_captcha" />
							<img src="./pub_img/par_ouv.png" alt="" class="im_captcha" />									
						</td>
						<td>
							<input type="text" name="captcha" />
						</td>
					</tr>	
					<tr>
						<td colspan="2" rowspan="1" class="form_spacer">
						</td>
					</tr>
					<tr>
						<td colspan="2" rowspan="1" class="form_center">
							<input type="submit" value="Valider" />
						</td>
					</tr>
				</table>
			</form>		
			');		
	}
}

?>